// SaveSetExplorer.cpp
/////////////////////////////////////////////////////////


// includes from ObjectARX Wizard
#include "stdafx.h"           // MFC stuff

#include "acdb.h"             // acdb definitions
#include "adslib.h"           // ads defs
#include "aced.h"             // aced stuff
#include "resourcehelper.h"   // temporary resource class
#include "rxmfcapi.h"         // ACAD MFC stuff
#include "QueryView.h"        // this project
#include "rxregsvc.h"         // unlock application

// message handlers
static void OnkLoadDwgMsg  (void);
static void OnkUnloadDwgMsg(void);
static void OnkEndMsg      (void);
static void OnkQuitMsg     (void);

// helper functions
static void initApp  (void);
static void unloadApp(void);

// MFC support
extern HWND adsw_acadMainWnd();
HINSTANCE _hdllInstance;
HWND hWndACAD = NULL;

extern void InitMFC();
extern void EndMFC();
BOOL InitModule(HINSTANCE, DWORD, LPVOID);

#include "DockPane.h"

CDockPane* pDockPane = NULL;

// end of declaration

/////////////////////////////////////////////////////////////////////
// acrxEntryPoint(internal)
// This function is the entry point for your application.
/////////////////////////////////////////////////////////////////////
extern "C" AcRx::AppRetCode acrxEntryPoint(AcRx::AppMsgCode msg, void* ptr)
{
  switch (msg) {
    case AcRx::kInitAppMsg:
	  acrxRegisterAppMDIAware(ptr);
      initApp();
      break;
    case AcRx::kUnloadAppMsg:
      unloadApp();
      break;
    case AcRx::kLoadDwgMsg:
      OnkLoadDwgMsg();
      break;
    case AcRx::kUnloadDwgMsg:
      OnkUnloadDwgMsg();
      break;
    case AcRx::kEndMsg:
      OnkEndMsg();
      break;
    case AcRx::kQuitMsg:
      OnkQuitMsg();
      break;
    default:
      break;
  }
  return AcRx::kRetOK;
}


static void OnkLoadDwgMsg(void)
{
  if(NULL != pDockPane)
	  pDockPane->OnLoadDwg();

  // end of message handler
}
static void OnkUnloadDwgMsg(void)
{
  if(NULL != pDockPane)
	  pDockPane->OnUnloadDwg();

  // end of message handler
}
static void OnkEndMsg(void)
{
  // TODO: add your message handler code here

  // end of message handler
}
static void OnkQuitMsg(void)
{
  // TODO: add your message handler code here

  // end of message handler
}

static void initApp(void)
{
  InitMFC();
  // register your autocad commands
  acedRegCmds->addCommand("QRYVIEW", "QRYVIEW", "QRYVIEW", ACRX_CMD_TRANSPARENT, qryview);
  // TODO: init your application

} // END initApp()

static void unloadApp(void)
{
  // unregister your autocad commands
  acedRegCmds->removeGroup("QRYVIEW");

  //if(NULL != pDockPane)
	 // pDockPane->UnloadAppMsg();

  EndMFC();
}


// MFC Initialization

void InitMFC()
{
  InitModule(_hdllInstance, DLL_PROCESS_ATTACH, NULL);
}

void EndMFC()
{
  InitModule(_hdllInstance, DLL_PROCESS_DETACH, NULL);
}

static AFX_EXTENSION_MODULE arxmfcDLL;

extern "C" APIENTRY
DllMain (HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_hdllInstance = hInstance;
	}
	return 1;
}

extern BOOL InitModule(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
  if (dwReason == DLL_PROCESS_ATTACH) {
    if (!AfxInitExtensionModule(arxmfcDLL, hInstance))
      return 0;

    CTemporaryResourceOverride::SetDefaultResource(_hdllInstance);
    // TODO: add other initialization tasks here

    // end of initialization
  } else if (dwReason == DLL_PROCESS_DETACH) {
    AfxTermExtensionModule(arxmfcDLL);
    // TODO: perform other cleanup tasks here

    // end of cleanup
  }
  return 1;
}

//////////////////////////////////////////////////////
void qryview()
{
	CFrameWnd *pMainFrame = NULL;
	{
		// when resource from this ARX app is needed,
		// instantiate a local object of CTemporaryResourceOverride    
		CTemporaryResourceOverride   useThisDllResource;

		pMainFrame = acedGetAcadFrame();
		ASSERT(pMainFrame);

		pDockPane = new CDockPane;
		assert(pDockPane);
	}

	pDockPane->Create(pMainFrame);
}

// END
